<?php

require_once __DIR__.'/vendor/autoload.php';

$loader = new Twig_Loader_Filesystem(__DIR__);
$twig = new Twig_Environment($loader, array(
    'cache' => false,
));

$uri = $_SERVER['REQUEST_URI'];

if (preg_match('/^\/$|^\/\?.+/', $uri)) {
    $viewfile = 'index.html.twig';
}
else {
    $viewfile = ltrim($uri,'/').'.html.twig';
}

if (file_exists(__DIR__.'/'.$viewfile)) {
    echo $twig->render($viewfile);
}
else {
    http_response_code(404);
    include('404.html');
    die();
}
